![3 Days of Swift](readme-images/ReadMe Screenshot.png) 

## The Swift Cheatsheet ⚡️
Courtesy of [3DaysOfSwift.com](https://www.3daysofswift.com/toolkit)

Created by 3DaysOfSwift.com.
A language reference guide in an Xcode playground file.
Developers should use this file to teach themselves basic Swift language features and to remind themselves of the Swift syntax they've forgotten without endless searching on the internet.

[Download Here](https://www.3daysofswift.com/toolkit)


## Swift.org Online Version of TSPL
Swift.org uses the contents of the book as a Language Guide to document each main language feature.

![Swift Language Guide](readme-images/Swift-org-language-guide.png)

[Officially supported HTML version](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/thebasics)

The official html version of the Swift Language Guide can be found [here](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/thebasics) and contains quite a huge amount of text. The Swift Cheatsheet is small, light and focusses on the executable code examples.

Simple & easy!


## What Is It?
An Xcode playground of executable code examples for all main Swift language features. Each playground page is organised by language feature. Developers should be able to quickly find the feature and execute the given example to refresh their knowledge of Swift syntax and how the code needs to be written to function.



## How To Become A Swift Engineer
Most companies who offer iOS developer jobs require maintenance for existing products (apps written in Swift). 

Today, a fast strategy to gain a job as a Junior iOS Developer may be to first learn the programming language (in order to pass an interview) and then learn UI and apps while employed and working on an existing product.

1. Learn Swift
2. Apply for jobs - fix bugs for existing products in Xcode
3. Learn about UI - maybe use A.I. to build UI
4. Learn about iOS apps 



## Why Learn Swift?
Wouldn't it make sense to build a career writing software for the worlds no.1 most profitable company? 

According to Fortune Global’s 500 list in 2020, Apple Inc was the global most profitable company reporting an annual profit of $57.41 billion US dollars. In a world with an ever increasing demand for smart devices iOS Developers will never be without work. 

In fact, those who study computer programming languages used by companies such as Apple, Microsoft, Google and Amazon will never be short of job offers and look forward to a very profitable and successful career.

[Swift](https://docs.swift.org) is the latest programming language chosen by Apple to write apps and  supporting frameworks for all iOS and macOS products. It was first released in June 2014 as a replacement for it's predecessor Objective-C. 



## Recommended Learning Path

**Step 1**: Learn the Swift programming language.

**Step 2**: Learn about code architecure and how to structure code (using TDD).

**Step 3**: Learn about UI and iOS apps while employed.



## Recommended Studying
We recommend studying the following Swift language features to become a Swift engineer.

1. [The Basics](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/thebasics)
2. [Control Flow](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/controlflow)
3. [Optionals](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/optionalchaining)
4. [Functions](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/functions) and [Closures](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/closures)
5. [Classes](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/classesandstructures)
6. [Structs](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/classesandstructures)
7. [Enums](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/enumerations)
8. [ARC](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/automaticreferencecounting) (Automatic Reference Counting)
9. [Extensions](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/extensions)
10. [Protocols](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/protocols)
11. [Concurrency](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/concurrency)
12. [Error Handling](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/errorhandling)
13. [Generics](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/generics)



--------------------------



![www.3DaysOfSwift.com](readme-images/3DaysIcon128.png)

[3DaysOfSwift.com](https://www.3DaysOfSwift.com)

Welcome to our community of [3DaysOfSwift](www.3DaysOfSwift.com) developers.



### 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️