![123 Calc](readme-images/123-calc.png)

## Professional Xcode Project 📱

![3 Days of Swift](readme-images/3DaysIcon128.png)
Courtesy of [3DaysOfSwift.com](https://www.3daysofswift.com/toolkit)

This Xcode project was created from the source code of the [3DaysOfSwift online course](https://www.3daysofswift.com/course) guided coursework. The UIKit version of the sourcecode generated an iOS app that was submitted to the AppStore. 

This repo contains the sourcecode with both UIKit and SwiftUI variations of the UI layer. 

Please use this project as a professional reference for how tidy and well-structured your own projects should be when coding to an industry-level of quality.

[Download Here](https://www.3daysofswift.com/toolkit)

----------------

![app icon](readme-images/123Calc-icon.png)

**App:** 123 Calc. Basic math calculator app. 

**Difficulty level:** Intermediate.

**Built With:** TDD *(Test Driven Development)*, dependency injection and POP *(Protocol Oriented Development)*




**Built To:** A professional level. Submitted to the AppStore. Buit using layered architecture and many modern development principles.

**Built By:** Professional senior iOS developers working in the tech industry. Swift Engineers with 15+ years experience in building iOS apps.

**Description:** A basic artithmetic calculator with different colour themes. This calculator has been built using some key programming concepts such as TDD *(Test Driven Development)*, dependency injection and POP *(Protocol Oriented Development)*. 

**Things to think about:** A rare opportunity to look at a professionally created Xcode project that was submitted to the AppStore. When learning Swift, it may be an interesting resource to obtain a professionally built product understanding how it was built, structured, tested and generally what the code looked like. We hope this helps to understand expectations of working in the tech industry. 

**Unit  tests:** This product was built by writing the tests first, which provided immediate feedback for each function and feature created helping us to know if our code works properly under all conditions and matches the expected behaviour. We recommend using TDD *(Test Driven development)* for all greenfield projects. 



## How To Become A Swift Engineer
Most companies who offer iOS developer jobs require maintenance for existing products (apps written in Swift). 

Today, a fast strategy to gain a job as a Junior iOS Developer may be to first learn the programming language (in order to pass an interview) and then learn UI and apps while employed and working on an existing product.

1. Learn Swift
2. Apply for jobs - fix bugs for existing products in Xcode
3. Learn about UI - maybe use A.I. to build UI
4. Learn about iOS apps 



## Why Learn Swift?
Wouldn't it make sense to build a career writing software for the worlds no.1 most profitable company? 

According to Fortune Global’s 500 list in 2020, Apple Inc was the global most profitable company reporting an annual profit of $57.41 billion US dollars. In a world with an ever increasing demand for smart devices iOS Developers will never be without work. 

In fact, those who study computer programming languages used by companies such as Apple, Microsoft, Google and Amazon will never be short of job offers and look forward to a very profitable and successful career.

[Swift](https://docs.swift.org) is the latest programming language chosen by Apple to write apps and  supporting frameworks for all iOS and macOS products. It was first released in June 2014 as a replacement for it's predecessor Objective-C. 



## Recommended Learning Path

**Step 1**: Learn the Swift programming language.

**Step 2**: Learn about code architecure and how to structure code (using TDD).

**Step 3**: Learn about UI and iOS apps while employed.



## Recommended Studying
We recommend studying the following Swift language features to become a Swift engineer.

1. [The Basics](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/thebasics)
2. [Control Flow](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/controlflow)
3. [Optionals](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/optionalchaining)
4. [Functions](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/functions) and [Closures](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/closures)
5. [Classes](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/classesandstructures)
6. [Structs](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/classesandstructures)
7. [Enums](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/enumerations)
8. [ARC](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/automaticreferencecounting) (Automatic Reference Counting)
9. [Extensions](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/extensions)
10. [Protocols](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/protocols)
11. [Concurrency](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/concurrency)
12. [Error Handling](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/errorhandling)
13. [Generics](https://docs.swift.org/swift-book/documentation/the-swift-programming-language/generics)



--------------------------



![www.3DaysOfSwift.com](readme-images/3DaysIcon128.png)

[3DaysOfSwift.com](https://www.3DaysOfSwift.com)

Welcome to our community of [3DaysOfSwift](www.3DaysOfSwift.com) developers.



### 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️